<?php

if ($vbulletin->options['radiostations_profile_info']) {
	# grab favorites from database
	$stations = array();
	
	$results = $db->query_read("
				SELECT *, r.stationid, COUNT(rt.stationid) as ratings, SUM(rt.rating) / COUNT(rt.stationid) AS average FROM " . TABLE_PREFIX . "radiostation_favorite AS rf
				LEFT JOIN " . TABLE_PREFIX . "radiostation AS r ON (r.stationid = rf.stationid)
				LEFT JOIN " . TABLE_PREFIX . "radiostation_rating AS rt ON (r.stationid = rt.stationid)
				LEFT JOIN " . TABLE_PREFIX . "radiostation_category AS c ON (r.categoryid = c.categoryid)
				WHERE rf.userid = " . $userinfo['userid'] . "
				GROUP BY r.stationid
				ORDER BY r.name ASC");
	
	$lastplayed = $db->query_first("
				SELECT * FROM " . TABLE_PREFIX . "radiostation_lastplayed as rlp
				LEFT JOIN " . TABLE_PREFIX . "radiostation AS r ON (r.stationid = rlp.stationid)
				WHERE rlp.userid = " . $userinfo['userid']);
	
	# make html output
	
	$output = '';
	$html = '';
	$title = $vbphrase['rs_favorite_stations_profile'];
	$id = 'favorite_stations_block';
	
	while( $station = $db->fetch_array( $results ) ) {
		$html .= '<a href="javascript:openRadioAndTV('. $station['stationid'] .')">'. htmlentities($station['name']) .'</a><br />';
	}
	
	if (empty($html)) {
		$html = $vbphrase['rs_no_favorites'] . '<br />';
	}
	
	if (empty($lastplayed['stationid'])) {
		$lastplayed = $vbphrase['rs_no_last_played'];
	} else {
		$lastplayed = '<a href="javascript:openRadioAndTV('. $lastplayed['stationid'] .')">'. htmlentities($lastplayed['name']) .'</a> ' . vbdate($vbulletin->options['dateformat'], $lastplayed['dateplayed'], true);
	}
	
	$html .= '<br />
	<dl class="smallfont list_no_decoration profilefield_list">
		<dt class="shade">'. $vbphrase['rs_last_played_profile'] .'</dt>
		<dd>'. $lastplayed .'</dd>
	</dl>
	';
	
	$html = '<div class="alt1 smallfont block_row">' . $html . '</div>
	<div class="alt2 smallfont block_row block_footer"><a href="javascript:openRadioAndTV()">'.$vbphrase['rs_open_radio_and_tv'].'</a></div>';
	
	eval('$output = "' . fetch_template('memberinfo_block') . '";');
	
	$template_hook['profile_right_album'] .= $output;
}

?>